/*****************************************************************************
*  LPC54xx blinky program for LPCXpresso board
*
*  1. Use SCT timer to generate a 100 msec toggle output @ SCT_OUT5
*  2. SCT_OUT5 is linked to P1_2 (Green LED) and toggles every 100 msec)
*****************************************************************************/

#include "board.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/
void SCT_Init(void);
/*****************************************************************************
 * Public functions
 ****************************************************************************/

void SCT_Init(void)
{

	Chip_SCT_Init(LPC_SCT);			                   						          						// enable the SCT clock

	Chip_SCT_Config(LPC_SCT, SCT_CONFIG_32BIT_COUNTER); 						      						// unified timers

	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_0,	(SystemCoreClock/10)-1);				  				// match 0 @ 10Hz = 100 msec
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, (SystemCoreClock/10)-1);


	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_0, ENABLE_STATE0);					  							// event 0 only happens in state 0
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T)   ( SCT_EVECTRL_MATCH0		|		// related to match 0
                                                                          SCT_COMBMODE_MATCH		|		// COMBMODE[13:12] = match condition only
                                                                          SCT_STATELD_1			    |		// STATELD[14] = STATEV is loaded into state
                                                                          SCT_STATEEV_1			    ));		// STATEV[15] = 1 (new state is 1)


	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_1, ENABLE_STATE1);					  							// event 1 only happens in state 1
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_1, (CHIP_SCT_EVENTCTRL_T)   ( SCT_EVECTRL_MATCH0		|		// related to match 0
                                                                          SCT_COMBMODE_MATCH		|		// COMBMODE[13:12] = match condition only
                                                                          SCT_STATELD_1			    |		// STATELD[14] = STATEV is loaded into state
                                                                          SCT_STATEEV_0			    ));		// STATEV[15] = 0 (new state is 0)


	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_5, SCT_EVT_0);													// event 0 will set SCT_OUT_5
	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_5, SCT_EVT_1);					    							// event 1 will clear SCT_OUT_5

	LPC_SCT->LIMIT_L           = 0x0003;                  						    						// events 0 and 1 are used as counter limit

	Chip_SCT_ClearControl(LPC_SCT, SCT_CTRL_HALT_L);							        					// start timer
}


int main(void)
{
  	SystemCoreClockUpdate();
  	Board_Init();

  	Chip_Clock_EnablePeriphClock((CHIP_SYSCON_CLOCK_T)  (SYSCON_CLOCK_IOCON	| SYSCON_CLOCK_GPIO1));									//enable IOCON clock and GPIO1 clock

  	Chip_IOCON_PinMuxSet(LPC_IOCON, 1, 2, IOCON_FUNC3 | IOCON_MODE_INACT | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);		//SCT0_OUT5 = P1.2  (green   LED)

    SCT_Init();                                           													// Initialize SCT

    while (1)                                              													// loop forever
    {
    	__WFI();
    }
}
